#version 330
#extension GL_EXT_gpu_shader4 : enable
//tie dye animMod01.fsh  by  _sans_titre 

//https://www.shadertoy.com/view/WsBcDD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159

vec3 palette(float l) {
    float m = 2.0*PI * l;
	return vec3(
    	cos(m),
        cos(m + 2.0 * PI / 3.0),
        cos(m + 3.0 * PI / 3.0)
    );
}

vec4 m = vec4(0.3);
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    if (iMouse.x > 0.0)
    	m = iMouse / iResolution.xyxy;
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    //uv += vec2(0.0, -1.5);
    float th = atan(uv.y, uv.x);
    float baseLength = length(uv*0.1);
    vec2 wavy = vec2(
        sin(th * 1.0 + iTime),
        cos(th * 23.0 + iTime)
    );
    float waveScale = max(0.01*m.x*100.01, baseLength * 0.2);
    wavy *= waveScale * m.y * 5.;
    float f = length(uv + wavy);
    f -= iTime / 10.0;
    f = floor(8.4 * f)/8.0;

    vec3 col = palette(f);
    col = pow(col, vec3(1.0/( m.y * 10.0)));

    // Output to screen
    gl_FragColor = vec4(col,1.0);

}